@extends('Employee/app')

@section('content')
<div class="container-fluid">
    <div class="row">

        <div class="col-md-10 col-md-offset-1">
            <h1>My Profile</h1>
    <ul class='breadcrumb'>
        <li><a href="{{ URL('admin/dashboard') }}">Home</a></li>
        <li><a href="#">Profile Tools</a></li>
        <li>View &amp; Update Profile</li>
    </ul>


            
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <strong>Whoops!</strong> There were some problems with your input.<br><br>
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                 @if (Session::has('message'))
                        <div class="alert alert-success">
                            <strong>  {{ Session('message') }} </strong>
                        </div>
                    @endif


                     

<div class="panel panel-default">
                <div class="panel-body">
                  @if(count($employees) > 0)
@foreach($employees as $emp)

                    <form class="form-horizontal" role="form" enctype="multipart/form-data" method="POST" action="{{ url('/employee/profileupd') }}">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <input type="hidden" name="id" value="{{ $emp->id }}">
<legend>Personal Details</legend>
<div class="col-md-12">
<div class="col-md-3" id="photo">
   
<div class="alert alert-default">
     <?php $rand=rand(1,1000);
        ?>
<img src="{{ asset('../uploads/photo/'.$emp->photo.'') }}?ver={{ $rand }}"  class="img-circle" />
<br /><br />
<input type="file" name="photo" value="" >
</div>
<div class="alert alert-default">
@if($emp->resume!="")
<a class="btn btn-danger btn-xs" href="{{ URL::to('../uploads/resume/' . $emp->resume) }}" target="_blank"><span class="glyphicon glyphicon-cloud-download" aria-hidden="true"></span> Download </a>
@else
No Resume Found!
@endif
<br /><br />
<input type="file" name="resume" value="" >
</div>
</div>

    <div class="col-md-9">
                        <div class="form-group">
                            <label class="col-md-4 control-label">Employee Name*</label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" name="name" value="{{ $emp->name }}">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label">Date of Birth*</label>
                            <div class="col-md-6">
                            <div class='input-group date'>
<input type='text' class="form-control" name="dob" id="date" data-provide="datepicker" value="{{ $emp->dob }}" />
  <span class="input-group-addon">
<span class="glyphicon glyphicon-calendar"></span>
</span></div>

                            </div>
                        </div>

                        <div class="form-group">    
                            <label class="col-md-4 control-label">Father/Husband*</label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" name="father" value="{{ $emp->father }}" >
                            </div>
                        </div>
                        <div class="form-group">    
                            <label class="col-md-4 control-label">Mobile*</label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" name="mobile" value="{{ $emp->mobile }}" >
                            </div>
                        </div>
                        <div class="form-group">    
                            <label class="col-md-4 control-label">Email*</label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" name="email" value="{{ $emp->email }}" >
                            </div>
                        </div>
<div class="form-group">    
                            <label class="col-md-4 control-label">Address*</label>
                            <div class="col-md-6">
                                <textarea name="address" class="form-control">{{ $emp->address }}</textarea>
                                
                            </div>
                        </div>
                                            
</div>    
</div>   

<hr />               
<legend>Social Profiles</legend> 

                        <div class="form-group">    
                            <label class="col-md-4 control-label">Facebook*</label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" name="facebook" value="{{ $emp->facebook }}" >
                            </div>
                        </div>
                        <div class="form-group">    
                            <label class="col-md-4 control-label">Twitter*</label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" name="twitter" value="{{ $emp->twitter }}" >
                            </div>
                        </div>
                        <div class="form-group">    
                            <label class="col-md-4 control-label">Linkedin*</label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" name="linkedin" value="{{ $emp->linkedin }}" >
                            </div>
                        </div>
                        <div class="form-group">    
                            <label class="col-md-4 control-label">Github*</label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" name="github" value="{{ $emp->github }}" >
                            </div>
                        </div>

                        
                        
<legend>Job Details</legend>

                        <div class="form-group">
                            <label class="col-md-4 control-label">Date of Join*</label>
                            <div class="col-md-6">
                            <div class='input-group date'>
<input type='text'  readonly class="form-control" name="doj2" id="date2" data-provide="datepicker" value="{{ $emp->doj }}" />
  <span class="input-group-addon">
<span class="glyphicon glyphicon-calendar"></span>
</span></div>

                            </div>
                        </div>
                            
<div class="form-group">    
                            <label class="col-md-4 control-label">Salary*</label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" name="salary2" value="{{ $emp->salary }}" 
                                readonly >
                                <input type="hidden" class="form-control" name="salary" value="{{ $emp->salary }}" >
 <input type="hidden" class="form-control" name="doj" value="{{ $emp->doj }}" >
 <input type="hidden" class="form-control" name="notes" value="{{ $emp->notes }}" >
 <input type="hidden" class="form-control" name="posting" value="{{ $emp->post_id }}" >
                            </div>
                        </div>  
<!--<div class="form-group">    
                            <label class="col-md-4 control-label">Notes*</label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" name="notes2" value="{{ $emp->notes }}" readonly >
                                
 
                            </div>
                        </div>                      -->
                            


                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                   Save Data
                                </button>
                            </div>
                        </div>
                    </form>
@endforeach
@endif                  
        </div>
    </div>
</div>


@endsection


