@extends('app')

@section('content')
  <article class="content items-list-page">
                    <div class="title-search-block">
                          
                        <div class="title-block">
                            <div class="row">
                                <div class="col-md-6">
                                    <h3 class="title">
                    Projects
                    <button type="button" class="btn btn-primary btn-sm rounded-s btn-pill-right" data-toggle="modal" data-target="#myModal"><i class="fa fa-location-arrow"></i> New Project </button>
                    <!--<a href="{{ url('admin/emp/create') }}" class="btn btn-primary btn-sm rounded-s">
                        <i class="fa fa-location-arrow"></i> New Appointment
                    </a> -->
                    
               <!-- <div class="action dropdown">
                        <button class="btn  btn-sm rounded-s btn-secondary dropdown-toggle" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Reports
                        </button>
                        <div class="dropdown-menu" aria-labelledby="dropdownMenu1">
                            <a class="dropdown-item" href="#">
                                <i class="fa fa-file-text icon"></i> Project Log Report</a>
                        </div>
                    </div> -->
                </h3>
                                    <p class="title-description"> 
        <ul class='breadcrumb'>
        <li><a href="{{ URL('admin/dashboard') }}"><i class="fa fa-home"></i> Dashboard</a></li>
        <li><a href="{{ URL('admin/projects') }}">Projects</a></li>

    </ul>
</p>
                                </div>
                            </div>
                        </div>
                        <div class="items-search">
                            <form class="form-inline" role="form" enctype="multipart/form-data" method="POST" action="{{ url('/admin/projects/search') }}">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                            <!--<form class="form-inline"> -->
                                <div class="input-group"> <input type="text" name="query" class="form-control boxed rounded-s" placeholder="Search for..."> <span class="input-group-btn">
                    <button class="btn btn-secondary rounded-s" type="submit">
                        <i class="fa fa-search"></i>
                    </button>
                </span> </div>
                            </form>
                        </div>
                    </div>
 @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <strong>Whoops!</strong> There were some problems with your input.<br><br>
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                 @if (Session::has('message'))
                        <div class="alert alert-success">
                            <strong>  {{ Session('message') }} </strong>
                        </div>
                    @endif
<section class="section">
                        <div class="row sameheight-container">
                            <div class="col-xl-12">
                                <div class="card sameheight-item">
                                    <div class="card-block">

                     @if(count($projects) > 0)


        <table class="table table-striped sortable">
                     <thead>
                         <tr>
                            <th>#</th>
                            <th>Project</th>
                            <th>Start Date</th>
                            <th>Deadline</th>
                            <th>Duration <small>(in days)</small></th>
                            <th>Status</th>
                         </tr>
                     </thead>
                     <tbody>
                      @foreach ($projects as $project)
                     <tr>
                            <td> {{ $project->id }}</td>
                            <td><a class=""  href="{{ URL::to('admin/projects/edit/' . $project->id) }}"><strong>{{ $project->proj_title }}</strong><i class="fa fa-external-link"></i></a><br />
                            {{ $project->proj_desc }}
                            </td>
<td>{{ $project->start_date }}</td>
<td>{{ $project->deadline }}</td>
<td>{{ $project->duration }} &nbsp;
    @if($project->status==0)
    @if($project->duration2<0)
    <span class="label label-danger">{{ $project->duration2 }} day(s) Overdue </span>
    @elseif($project->duration2<6)
    <span class="label label-warning">{{ $project->duration2 }} day(s) to complete </span>
    @elseif($project->duration2<10)
    <span class="label label-info">{{ $project->duration2 }} day(s) to complete </span>
    @else
    <span class="label label-success">{{ $project->duration2 }} day(s) to complete </span>
    @endif
    @endif
</td>
<td> 
    @if($project->status==1)
    <span class="label label-success label-lg">Finished</span>
    @elseif($project->status==2)
    <span class="label label-danger">Stopped</span>
    @else
    <span class="label label-primary">On Going</span>
    @endif
    
<!--<a class="btn btn-link2 btn-xs" href="{{ URL::to('admin/projects/delete/' . $project->id) }}"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span> </a> -->

                            </td>
                        </tr>
                         @endforeach
                     </tbody>

                     </table>
                        <nav class="text-xs-right">
                       {!! str_replace('/?', '?', $projects->render()) !!}
</nav>
                    @else
                       <h3>No Data Found!</h3>
                    @endif
                    </div>
  </div>
                                    <!-- /.card-block -->
                                </div>
                                <!-- /.card -->
                            </div>
                           
                        </div>
                    </section>      
                   
                </article>



<!-- new creation -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">

  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="myModalLabel"><i class="fa fa-location-arrow"></i> New Project</h4>
      </div>
      <div class="modal-body">
 <form class="form-horizontal" role="form" method="POST" action="{{ url('/admin/projects/docreate') }}">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">

                        <div class="form-group">
                            <label class="control-label">Project Title*</label>
                            
                                <input type="text" class="form-control underlined" name="title" value="">
                            
                        </div>

                        <div class="form-group">
                            <label class="control-label">Project Specification*</label>
                            
                                <input type="text" class="form-control underlined" name="description" value="" >
                            
                        </div>

                        <div class="form-group">
                            <label class="control-label">Project Date*</label>
                            
                            <div class='input-group date'>
<input type='text' class="form-control underlined" id="date-start" name="start_date" data-provide="datepicker" />
  <span class="input-group-addon">
<span class="glyphicon glyphicon-calendar"></span>
</span></div>

                            
                        </div>
                        <div class="form-group">
                            <label class="control-label">Deadline Date*</label>
                            
                            <div class='input-group date'>
<input type='text' class="form-control underlined" id="date-end" name="deadline" data-provide="datepicker" />
  <span class="input-group-addon">
<span class="glyphicon glyphicon-calendar"></span>
</span></div>

                            
                        </div>
<div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal"><i class="fa fa-times"></i> Cancel</button>
        <button type="submit" class="btn btn-primary"><i class="fa fa-check"></i> Save changes</button>
        </form>
      </div>
            
                                
      
                       

      </div>
      
    </div>
  </div>
</div>

        
    </div>
  </div>
</div>
</div></div></div>



@endsection
